#include <bits/stdc++.h>

using namespace std;

#define lli long long int

lli polygon_area(const vector<pair<int, int>> &points) {
  lli area = 0;
  int n = points.size();
  for (int i = 0; i < n; i++) {
    area += static_cast<lli>(points[i].first) * points[(i + 1) % n].second;
    area -= static_cast<lli>(points[(i + 1) % n].first) * points[i].second;
  }

  return abs(area) / 2;
}

vector<pair<int, int>> convert_points(vector<pair<int, int>> &points) {
  sort(points.begin(), points.end());
  vector<pair<int, int>> hull;

  for (const auto &p : points) {
    while (
        hull.size() >= 2 &&
        (hull[hull.size() - 1].first - hull[hull.size() - 2].first) *
                    (p.second - hull[hull.size() - 1].second) -
                (hull[hull.size() - 1].second - hull[hull.size() - 2].second) *
                    (p.first - hull[hull.size() - 1].first) <=
            0) {
      hull.pop_back();
    }
    hull.push_back(p);
  }

  int lowerSize = hull.size();
  for (int i = points.size() - 1; i >= 0; i--) {
    const auto &p = points[i];
    while (
        hull.size() > lowerSize &&
        (hull[hull.size() - 1].first - hull[hull.size() - 2].first) *
                    (p.second - hull[hull.size() - 1].second) -
                (hull[hull.size() - 1].second - hull[hull.size() - 2].second) *
                    (p.first - hull[hull.size() - 1].first) <=
            0) {
      hull.pop_back();
    }
    hull.push_back(p);
  }

  hull.pop_back();
  return hull;
}

int main() {
  int n;
  cin >> n;
  vector<pair<int, int>> points(n);

  for (int i = 0; i < n; i++) {
    cin >> points[i].first >> points[i].second;
  }

  lli min_area = numeric_limits<lli>::max();
  for (int i = 0; i < n; i++) {
    vector<pair<int, int>> remaining = points;
    remaining.erase(remaining.begin() + i);
    min_area = min(min_area, polygon_area(convert_points(remaining)));
  }

  cout << min_area << endl;
  return 0;
}